/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class NetworkDiagnosticsPartOverlayRenderer {
    private static final NetworkDiagnosticsPartOverlayRenderer _INSTANCE = new NetworkDiagnosticsPartOverlayRenderer();
    private final Set<PartPos> partPositions = Sets.newHashSet();

    private NetworkDiagnosticsPartOverlayRenderer() {
    }

    public static NetworkDiagnosticsPartOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    public synchronized void addPos(PartPos pos) {
        this.partPositions.add(pos);
    }

    public synchronized void removePos(PartPos pos) {
        this.partPositions.remove(pos);
    }

    public synchronized void clearPositions() {
        this.partPositions.clear();
    }

    public synchronized boolean hasPartPos(PartPos pos) {
        return this.partPositions.contains(pos);
    }

    @SubscribeEvent
    public void onRender(RenderLevelLastEvent event) {
        if (!this.partPositions.isEmpty()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            float partialTicks = event.getPartialTick();
            double offsetX = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
            double offsetY = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partialTicks;
            double offsetZ = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_69832_((float)6.0f);
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            ArrayList partList = Lists.newArrayList(this.partPositions);
            for (PartPos partPos : partList) {
                if (!partPos.getPos().getLevelKey().m_135782_().equals((Object)player.f_19853_.m_46472_().m_135782_()) || !(partPos.getPos().getBlockPos().m_123331_((Vec3i)player.m_142538_()) < 10000.0)) continue;
                PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
                VoxelShape shape = partStateHolder != null ? partStateHolder.getPart().getPartRenderPosition().getBoundingBox(partPos.getSide()) : Shapes.f_83037_;
                AABB aABB = shape.m_83215_().m_82338_(partPos.getPos().getBlockPos()).m_82386_(-offsetX, -offsetY, -offsetZ).m_82377_(0.05, 0.05, 0.05).m_82377_(-0.05, -0.05, -0.05);
            }
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }
    }
}

